package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.HeartRateConverter;
import gov.va.med.mhv.vitals.dto.HeartRateReadingDTO;
import gov.va.med.mhv.vitals.model.HeartRateReading;
import gov.va.med.mhv.vitals.repository.HeartRateReadingRepository;
import gov.va.med.mhv.vitals.service.HeartRateService;
import gov.va.med.mhv.vitals.validator.HeartRateValidator;

@Component
public class HeartRateServiceImpl implements HeartRateService{
	
	private static Logger log = LogManager.getLogger(HeartRateServiceImpl.class);
	
	@Autowired
	private HeartRateReadingRepository hrRepository;
	
	@Autowired
	private HeartRateValidator validator;


	@Override
	public ResponseUtil<Long> save(HeartRateReadingDTO heartRateDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.heartRateValidations(response, heartRateDTO);
		if(response.getValidationErrors().size() == 0){
			HeartRateReading hrReading = HeartRateConverter.convertHeartRateReadingDTO(heartRateDTO);
			hrReading = hrRepository.save(hrReading);
			response.setSuccess(true);
			response.setPojoObject(hrReading.getId());
		}else{
			log.debug("Validation Errors in save Heart Rate reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil<Void> delete(Long id) {
		ResponseUtil<Void> response = new ResponseUtil<Void>();
		hrRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		HeartRateReading hrReading = hrRepository.findOne(id);
		if(hrReading != null){
			HeartRateReadingDTO heartRateDTO = HeartRateConverter.convertHeartRateReadingDomain(hrReading);
			response.setPojoObject(heartRateDTO);
			response.setSuccess(true);
		}else{
			log.debug("HeartRate Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<HeartRateReadingDTO>> getHeartRateReadingsForUser(Long userprofileid) {
		ResponseUtil response = new ResponseUtil();
		List<HeartRateReading> hrReadings=hrRepository.getHeartRateReadingsForUser(userprofileid);
		if(hrReadings != null){
			List<HeartRateReadingDTO> dtos = HeartRateConverter.convertHeartRateReadings(hrReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("HeartRate Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<HeartRateReadingDTO>> getHeartRateDashBoardReadingsForUser(Long userprofileid) {
		ResponseUtil<List<HeartRateReadingDTO>> response = new ResponseUtil<List<HeartRateReadingDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<HeartRateReading> hrReadings=hrRepository.getDashBoardHeartRateReadingsForUser(userprofileid, topFive);
		if(hrReadings != null){
			List<HeartRateReadingDTO> dtos = HeartRateConverter.convertHeartRateReadings(hrReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("HeartRate Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<HeartRateReadingDTO> getHeartRateReadingByid(Long userProfileId, Long id) {
		ResponseUtil<HeartRateReadingDTO> response = new ResponseUtil<HeartRateReadingDTO>();
		HeartRateReading hrReading = hrRepository.findOne(id);
		if(hrReading != null){
			HeartRateReadingDTO dto=HeartRateConverter.convertHeartRateReadingDomain(hrReading);
			response.setPojoObject(dto);
		}else{
			log.debug("Heart Rate Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}
}
